package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.MarketPositionDTO;

import java.util.List;

/**
 * 营销位远程调用Service
 */
@AdvancedFeignClient
public interface RemoteMarketPositionService {
    /**
     * 新增数据
     *
     * @param marketPositionDTO
     * @return
     */
    Boolean insert(MarketPositionDTO marketPositionDTO);

    /**
     * 依据主键删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 修改数据
     *
     * @param marketPositionDTO
     * @return
     */
    Boolean update(MarketPositionDTO marketPositionDTO);

    /**
     * 修改营销位状态
     *
     * @param id
     * @param marketStatus
     * @return
     */
    public Boolean updateMarketStatus(Long id, Integer marketStatus);

    /**
     * 依据主键查询数据
     *
     * @param id
     * @return
     */
    MarketPositionDTO queryOneById(Long id);

    /**
     * 查询全部数据
     *
     * @return
     */
    List<MarketPositionDTO> queryList();

    /**
     * 依据页面标识符查询数据
     *
     * @param pageIdentifier
     * @return
     */
    List<MarketPositionDTO> queryListByPageIdentifier(Integer pageIdentifier);

    /**
     * 依据页面标识符和展示类型查询数据
     *
     * @param pageIdentifier
     * @param showType
     * @return
     */
    MarketPositionDTO queryOneByPageIdentifierAndShowType(Integer pageIdentifier, Integer showType);

}
