package cn.yoofans.knowledge.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponBatchGrantDto;
import org.springframework.data.domain.PageImpl;

/**
 * @author zhanghuifeng
 * @date 2018/8/9下午8:01
 */
@AdvancedFeignClient
public interface RemoteCouponBatchGrantService {

    /**
     * 分页查询优惠券信息
     * @param pageNum
     * @param pageSize
     * @param couponTemplateId
     * @return
     */
    PageImpl<CouponBatchGrantDto> findPage(Integer pageNum, Integer pageSize, String couponTemplateId);

    /**
     * 新增
     * @param dto
     * @return 主键ID
     */
    Long insert(CouponBatchGrantDto dto);

    /**
     * 更新
     * @param dto
     * @return
     */
    Boolean update(CouponBatchGrantDto dto);
}
