package cn.yoofans.knowledge.center.api.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * Created by zhangshun on 2018/5/25,09:08:40.
 */
public class ReadDayUtils {

    public static String diffDate(Date date1) {

        Calendar date = Calendar.getInstance();
        date.setTime(date1);
        date.set(Calendar.HOUR_OF_DAY, 0);
        date.set(Calendar.MINUTE, 0);
        date.set(Calendar.SECOND, 0);
        date.set(Calendar.MILLISECOND, 0);

        Calendar today = Calendar.getInstance();

        today.set(Calendar.HOUR_OF_DAY, 23);
        today.set(Calendar.MINUTE, 59);
        today.set(Calendar.SECOND, 59);
        today.set(Calendar.MILLISECOND, 999);
        if (today.getTime().before(date.getTime())) {
            return "after"; // 之后
        }

        today.set(Calendar.HOUR_OF_DAY, 0);
        today.set(Calendar.MINUTE, 0);
        today.set(Calendar.SECOND, 0);
        today.set(Calendar.MILLISECOND, 0);

        //date.add(Calendar.DATE, 1);
        if (today.getTime().after(date.getTime())) {
            return "before"; // 之前
        }

        return "today";
    }

    /**
     * 已开课几天
     *
     * @param beginDate
     * @param clockDate
     * @return
     */
    public static Integer getReadPastDays(Date beginDate, Date clockDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("打卡日期错误");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return Math.abs((int) ((end.toEpochDay() - begin.toEpochDay()) + 1));
    }

    /**
     * 还要几天开课
     *
     * @param beginDate
     * @param clockDate
     * @return
     */
    public static Integer getReadAfterDays(Date beginDate, Date clockDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("打卡日期错误");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return Math.abs((int) (end.toEpochDay() - begin.toEpochDay()));
    }

    /**
     * 共几天
     */
    public static Integer getTotalDays(Date beginDate, Date endDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(endDate)) {
            throw new RuntimeException("结束日期错误");
        }

        if (beginDate.after(endDate)) {
            throw new RuntimeException("开课日期不能大于结束日期");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return (int) (end.toEpochDay() - begin.toEpochDay()) + 1;
    }
}
