package cn.yoofans.knowledge.center.api.dto.distribution;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import cn.yoofans.knowledge.center.api.enums.PosterItemTypeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 海报实体类
 */
public class PosterDTO extends BaseDTO implements Serializable {

    private static final long serialVersionUID = 173480464484141491L;

    /**
     * 商品类型：1单课2专栏商品id,公共海报时该字段为0
     * {@link PosterItemTypeEnum}
     */
    private Integer itemType;

    /**
     * 商品id,公共海报/阅读计划时该字段为0
     */
    private Long itemId;

    /**
     * 海报图片地址
     */
    private String poster;

    /**
     * 海报小图地址
     */
    private String smallPoster;

    /**
     * 头像长度
     */
    private Integer portraitLength;

    /**
     * 头像左边距
     */
    private Integer portraitLeftMargin;

    /**
     * 头像上边距
     */
    private Integer portraitTopMargin;

    /**
     * 圆角比例
     */
    private Integer portraitRoundProportion;

    /**
     * 头像是否显示 0：隐藏 1：显示
     */
    private Integer portraitDisplay;

    /**
     * 昵称宽度
     */
    private Integer nicknameWidth;

    /**
     * 昵称高度
     */
    private Integer nicknameHeight;

    /**
     * 昵称左边距
     */
    private Integer nicknameLeftMargin;

    /**
     * 昵称上边距
     */
    private Integer nicknameTopMargin;

    /**
     * 昵称字号
     */
    private Integer nicknameFontSize;

    /**
     * 昵称字体颜色
     */
    private String nicknameFontColor;

    /**
     * 昵称显示 0：隐藏 1：显示
     */
    private Integer nicknameDisplay;

    /**
     * 课程标题宽度
     */
    private Integer ctitleWidth;

    /**
     * 课程标题高度
     */
    private Integer ctitleHeight;

    /**
     * 课程标题左边距
     */
    private Integer ctitleLeftMargin;

    /**
     * 课程标题上边距
     */
    private Integer ctitleTopMargin;

    /**
     * 课程标题字体大小
     */
    private Integer ctitleFontSize;

    /**
     * 课程标题字体颜色
     */
    private String ctitleFontColor;

    /**
     * 课程标题显示 0：隐藏 1：显示
     */
    private Integer ctitleDisplay;

    /**
     * 二维码宽度
     */
    private Integer qrcodeLength;

    /**
     * 二维码左边距
     */
    private Integer qrcodeLeftMargin;

    /**
     * 二维码上边距
     */
    private Integer qrcodeTopMargin;

    /**
     * 排序字段
     */
    private Long sort;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getSmallPoster() {
        return smallPoster;
    }

    public void setSmallPoster(String smallPoster) {
        this.smallPoster = smallPoster;
    }

    public Integer getPortraitLength() {
        return portraitLength;
    }

    public void setPortraitLength(Integer portraitLength) {
        this.portraitLength = portraitLength;
    }

    public Integer getPortraitLeftMargin() {
        return portraitLeftMargin;
    }

    public void setPortraitLeftMargin(Integer portraitLeftMargin) {
        this.portraitLeftMargin = portraitLeftMargin;
    }

    public Integer getPortraitTopMargin() {
        return portraitTopMargin;
    }

    public void setPortraitTopMargin(Integer portraitTopMargin) {
        this.portraitTopMargin = portraitTopMargin;
    }

    public Integer getPortraitRoundProportion() {
        return portraitRoundProportion;
    }

    public void setPortraitRoundProportion(Integer portraitRoundProportion) {
        this.portraitRoundProportion = portraitRoundProportion;
    }

    public Integer getPortraitDisplay() {
        return portraitDisplay;
    }

    public void setPortraitDisplay(Integer portraitDisplay) {
        this.portraitDisplay = portraitDisplay;
    }

    public Integer getNicknameWidth() {
        return nicknameWidth;
    }

    public void setNicknameWidth(Integer nicknameWidth) {
        this.nicknameWidth = nicknameWidth;
    }

    public Integer getNicknameHeight() {
        return nicknameHeight;
    }

    public void setNicknameHeight(Integer nicknameHeight) {
        this.nicknameHeight = nicknameHeight;
    }

    public Integer getNicknameLeftMargin() {
        return nicknameLeftMargin;
    }

    public void setNicknameLeftMargin(Integer nicknameLeftMargin) {
        this.nicknameLeftMargin = nicknameLeftMargin;
    }

    public Integer getNicknameTopMargin() {
        return nicknameTopMargin;
    }

    public void setNicknameTopMargin(Integer nicknameTopMargin) {
        this.nicknameTopMargin = nicknameTopMargin;
    }

    public Integer getNicknameFontSize() {
        return nicknameFontSize;
    }

    public void setNicknameFontSize(Integer nicknameFontSize) {
        this.nicknameFontSize = nicknameFontSize;
    }

    public String getNicknameFontColor() {
        return nicknameFontColor;
    }

    public void setNicknameFontColor(String nicknameFontColor) {
        this.nicknameFontColor = nicknameFontColor;
    }

    public Integer getNicknameDisplay() {
        return nicknameDisplay;
    }

    public void setNicknameDisplay(Integer nicknameDisplay) {
        this.nicknameDisplay = nicknameDisplay;
    }

    public Integer getCtitleWidth() {
        return ctitleWidth;
    }

    public void setCtitleWidth(Integer ctitleWidth) {
        this.ctitleWidth = ctitleWidth;
    }

    public Integer getCtitleHeight() {
        return ctitleHeight;
    }

    public void setCtitleHeight(Integer ctitleHeight) {
        this.ctitleHeight = ctitleHeight;
    }

    public Integer getCtitleLeftMargin() {
        return ctitleLeftMargin;
    }

    public void setCtitleLeftMargin(Integer ctitleLeftMargin) {
        this.ctitleLeftMargin = ctitleLeftMargin;
    }

    public Integer getCtitleTopMargin() {
        return ctitleTopMargin;
    }

    public void setCtitleTopMargin(Integer ctitleTopMargin) {
        this.ctitleTopMargin = ctitleTopMargin;
    }

    public Integer getCtitleFontSize() {
        return ctitleFontSize;
    }

    public void setCtitleFontSize(Integer ctitleFontSize) {
        this.ctitleFontSize = ctitleFontSize;
    }

    public String getCtitleFontColor() {
        return ctitleFontColor;
    }

    public void setCtitleFontColor(String ctitleFontColor) {
        this.ctitleFontColor = ctitleFontColor;
    }

    public Integer getCtitleDisplay() {
        return ctitleDisplay;
    }

    public void setCtitleDisplay(Integer ctitleDisplay) {
        this.ctitleDisplay = ctitleDisplay;
    }

    public Integer getQrcodeLength() {
        return qrcodeLength;
    }

    public void setQrcodeLength(Integer qrcodeLength) {
        this.qrcodeLength = qrcodeLength;
    }

    public Integer getQrcodeLeftMargin() {
        return qrcodeLeftMargin;
    }

    public void setQrcodeLeftMargin(Integer qrcodeLeftMargin) {
        this.qrcodeLeftMargin = qrcodeLeftMargin;
    }

    public Integer getQrcodeTopMargin() {
        return qrcodeTopMargin;
    }

    public void setQrcodeTopMargin(Integer qrcodeTopMargin) {
        this.qrcodeTopMargin = qrcodeTopMargin;
    }

    public Long getSort() {
        return sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}