package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券母版发放优惠券标志枚举
 *
 * @author qiuyp
 */
public enum CouponHandOutEnum {
    NO(0, "未发放"),
    YES(1, "已发放");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponHandOutEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponHandOutEnum getByCode(Integer code) {
        for (CouponHandOutEnum enumVal : CouponHandOutEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
