package cn.yoofans.knowledge.center.api.enums.course;

import java.util.Objects;

/**
 * 讲义重点枚举
 * Created by qiuyp
 */
public enum HandoutKeySignEnum {

    COMMON(0, "非重点"),
    IMPORTANT(1, "重点");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    HandoutKeySignEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static HandoutKeySignEnum getByCode(Integer code) {
        for (HandoutKeySignEnum value : HandoutKeySignEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
