package cn.yoofans.knowledge.center.api.enums.distribution;

/**
 * 分销类型枚举
 * @author zhanghuifeng
 * @date 2018/7/31下午5:31
 */
public enum DistributionTypeEnum {

    COMMON(1, "普通分销"),
    INVITE(2, "邀请分销");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    DistributionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static DistributionTypeEnum getByCode(Integer code) {
        if (code == null){
            return null;
        }
        for (DistributionTypeEnum status : DistributionTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
