package cn.yoofans.knowledge.center.api.enums.jdgiftbook;

/**
 * 专栏枚举类
 */
public enum GiftBookOrderStatusEnum {

    WAIT_PAY(1, "待支付"),//d对于前端映射1,代发货,2已发货,3发货失败

    ALREADY_PAY(2, "已支付");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    GiftBookOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static GiftBookOrderStatusEnum getByCode(Integer code) {
        for (GiftBookOrderStatusEnum status : GiftBookOrderStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
