package cn.yoofans.knowledge.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.card.CardRelationDto;
import cn.yoofans.knowledge.center.api.param.billboard.BillBoardPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCardRelationService {

    Boolean deleteById(Long id);

    Long save(CardRelationDto entity);

    CardRelationDto selectById(Long id);

    List<CardRelationDto> selectRelationIdsByCardId(Long cardId,Integer relationType);

    /**
     * deleteByCardId
     * 根据卡片id删除关联关系
     */
    Boolean deleteByCardId(Long cardId);

    /**
     * 更新卡片关联关系
     */
    Boolean updateCardRelation(Long cardId,List<Long> readIds);

}