package cn.yoofans.knowledge.center.api.remoteservice.jdinterface;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.param.jdBean.JDresult;
import cn.yoofans.knowledge.center.api.param.jdBean.Result;

import java.util.Map;

/**
 * @author zhangmm
 * @Description: rpc--jd
 * @date 2018/9/18 0018 15:49
*/
@AdvancedFeignClient
public interface RemoteJDInterfaceService {

    /**
     * @author zhangmm
     * @Description: 获取token
     * @date 2018/9/4 0004 11:58
     */
    JDresult getAccessToken() ;

    /**
     * @author zhangmm
     * @Description: 获取商品池编号接口
     * @date 2018/9/4 0004 11:58
     */
    JDresult getPageNum() ;

    /**
     * @author zhangmm
     * @Description: 获取商品池编号接口
     * @date 2018/9/4 0004 11:58
     */
    JDresult getSkuByPage(String pageNum, String pageNo) ;

    /**
     * @author zhangmm
     * @Description: 获取商品详细信息接口
     * @date 2018/9/4 0004 11:58
     */
    JDresult getDetail(String sku, String queryExts) ;

    /**
     * @author zhangmm
     * @Description: 获取商品上下架状态接口
     * @date 2018/9/4 0004 11:58
     */
    JDresult skuState(String sku) ;

    /**
     * @author zhangmm
     * @Description: 获取一级地址
     * @date 2018/9/4 0004 11:58
     */
    JDresult<Map<Integer,String>> getProvince();

    /**
     * @author zhangmm
     * @Description: 获取二级地址
     * @date 2018/9/4 0004 11:58
     */
    JDresult<Map<Integer,String>> getCity(String proviceId);

    /**
     * @author zhangmm
     * @Description: 获取三级地址
     * @date 2018/9/4 0004 11:58
     */
    JDresult<Map<Integer,String>> getCounty(String cityId) ;

    /**
     * @author zhangmm
     * @Description: 信息推送接口
     * @date 2018/9/4 0004 11:58
     */
    JDresult getInfo(String type) ;

    Result selectJdOrder(String orderId, String queryExts) ;

}
