package cn.yoofans.knowledge.center.api.enums;

/**
 * 课程类型枚举类
 */
public enum CourseTypeEnum {

    AUDIO(1, "音频"),

    VIDEO(2, "视频"),

    READ(4, "阅读");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CourseTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static CourseTypeEnum getByCode(Integer code) {
        for (CourseTypeEnum status : CourseTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
