package cn.yoofans.knowledge.center.api.enums;

/**
 * 课程/专栏权限等级类型枚举类
 */
public enum PowerLevelEnum {

    NOT_PURCHASED(0, "未购买"),

    PURCHASED(1, "已购买");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    PowerLevelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的类型
     *
     * @param code
     * @return
     */
    public static PowerLevelEnum getByCode(Integer code) {
        for (PowerLevelEnum status : PowerLevelEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
