package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券状态枚举
 *
 * @author zhanghuifeng
 * @date 2018/4/25下午4:53
 */
public enum CouponInfoStatusEnum {
    OUT_TIME(-1, "已过期"),
    READY_USE(0, "待使用"),
    ALREADY_USED(1, "已使用");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponInfoStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponInfoStatusEnum getByCode(Integer code) {
        for (CouponInfoStatusEnum enumVal : CouponInfoStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
