package cn.yoofans.knowledge.center.api.enums.test;

import java.util.Objects;

/**
 * 测试计划查询状态枚举类
 * Created by qiuyp
 */
public enum PlanQueryStatusEnum {

    OFF_LINE(-1, "已下线"),
    PAUSE(0, "已暂停"),
    RUNNING(1, "运行中"),
    STOPPED(2, "已结束"),
    NOT_BEGIN(3, "未开始"),
    ALL(4, " 全部");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    PlanQueryStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static PlanQueryStatusEnum getByCode(Integer code) {
        for (PlanQueryStatusEnum value : PlanQueryStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
