/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteReadService
 * Author:   amu
 * Date:     2018/5/22 下午7:29
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadDTO;
import cn.yoofans.knowledge.center.api.dto.read.ReadListDTO;
import cn.yoofans.knowledge.center.api.param.read.ReadSearchParam;

/**
 * 〈一句话功能简述〉<br>
 * 〈计划远程服务类〉
 *
 * @author amu
 * @create 2018/5/22
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteReadService {

    /**
     * 首页查询
     *
     * @param userId
     * @param readId
     * @return
     */
    ReadListDTO readById(Long userId, Long readId);

    /**
     * 首页查询
     *
     * @return
     */
    List<ReadListDTO> readList(Long userId);

    /**
     * 根据ID获取阅读信息
     * <p>
     * 已经使用redis缓存
     *
     * @param id
     * @return
     */
    ReadDTO getById(Long id);

    /**
     * 修改 / 保存
     *
     * @param readDTO
     * @return
     */
    int save(ReadDTO readDTO);

    /**
     * 修改状态
     *
     * @param readDTO
     * @return
     */
    int changeStatus(ReadDTO readDTO);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 分页查询个数
     *
     * @param param
     * @return
     */
    Long countByPage(ReadSearchParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<ReadDTO> findByPage(ReadSearchParam param);

    /**
     * 按照id数组查询
     *
     * @param ids
     * @return
     */
    List<ReadDTO> findByIds(List<Long> ids);

    /**
     * 下单时,获取阅读期数, 请使用 RemoteReadStageService.getStageId
     *
     * @param readId
     * @return
     */
    @Deprecated
    Long getStageId(Long readId);

    /**
     * 查询阅读计划简易信息列表
     *
     * @param id
     * @param title
     * @param status
     * @return
     */
    List<ReadDTO> getSimpleInfoList(Long id, String title, Integer status);

    Map<Long, String> findByIdList(List<Long> idList);

    List<Long> findBySaleMark(Integer saleMark);

    /**
     * 查询正式,上线的阅读计划
     */
    ReadDTO findOneByIdsAndFormalAndOnline(List<Long> ids);

    ReadDTO findByReadSaleMark(Integer saleMark);

}
