/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteRefundService
 * Author:   amu
 * Date:     2018/8/8 下午3:33
 * Description: 退款接口
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.refund;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.refund.RefundResultDTO;
import cn.yoofans.knowledge.center.api.enums.refund.RefundTypeEnum;
import cn.yoofans.knowledge.center.api.param.read.RefundQueryParam;
import cn.yoofans.knowledge.center.api.param.refund.AsyncRefundParams;
import cn.yoofans.knowledge.center.api.param.refund.RefundParams;

/**
 * 〈一句话功能简述〉<br>
 * 〈退款接口〉
 *
 * @author amu
 * @create 2018/8/8
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteRefundService {
    /**
     * 申请退款接口
     *
     * @param params
     * @param refundTypeEnum
     * @return
     */
    Boolean refundOreder(RefundParams params, RefundTypeEnum refundTypeEnum) throws BizException;

    /**
     * 校验签名
     *
     * @param map
     * @param payType
     * @return
     */
    Boolean checkSign(String map, String payType);

    /**
     * 查询退款接口
     *
     * @return
     */
    RefundResultDTO refundQuery(RefundQueryParam param) throws BizException;

    /**
     * 退款成功
     *
     * @param params
     * @return
     */
    Boolean refundSuccess(AsyncRefundParams params) throws BizException;

    /**
     * 退款失败
     *
     * @return
     */
    Boolean refundError(AsyncRefundParams params);

    /**
     * 继续退款
     *
     * @param appId         应用Id
     * @param orderId       订单id
     * @param refundErrorId 退款异常记录id
     * @return
     */
    Boolean keepRefund(String appId, String orderId, Long refundErrorId) throws BizException;

    /**
     * 退款微信回调
     *
     * @param params
     * @return
     * @throws BizException
     */
    Boolean refundNotify(AsyncRefundParams params) throws BizException;

}
