package cn.yoofans.knowledge.center.api.util;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @Author danke
 * @Date :Create in 下午4:22 2018/8/6
 */
public class YooFanStringUtils extends StringUtils {

    private static final String SEP = ",";

    private YooFanStringUtils() {
    }

    /**
     * 默认值为空集合
     * @param content
     * @return
     */
    public static List<String> stringToList(String content){
        if (isBlank(content)){
            return Lists.newArrayList();
        }
        String[] imageArr = content.split(SEP);
        return Lists.newArrayList(imageArr);
    }

    /**
     * 默认值为 null
     * @param lists
     * @return
     */
    public static String listToStringBySep(List<String> lists){
        if (CollectionUtils.isEmpty(lists)){
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0;i<lists.size();i++) {
            sb.append(lists.get(i));
            if (i<(lists.size()-1)){
                sb.append(SEP);
            }
        }
        return sb.toString();
    }
}
