package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 批量生成优惠券当前状态
 * @author zhanghuifeng
 * @date 2018/8/9下午6:57
 */
public enum CouponBatchGrantOperateStateEnum {
    NOT_GRANT(1, "未生成"),
    GRANTING(2, "生成中"),
    GRANTED(3, "已生成"),
    DOWNLOADED(4, "已下载");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponBatchGrantOperateStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponBatchGrantOperateStateEnum getByCode(Integer code) {
        for (CouponBatchGrantOperateStateEnum enumVal : CouponBatchGrantOperateStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
