package cn.yoofans.knowledge.center.api.enums.page;

/**
 * tb_item_detail_page表产品类型枚举
 * @author zhanghuifeng
 * @date 2018/7/5下午2:26
 */
public enum ItemTypeEnum {

    READ_PLAN(1, "阅读计划"),
    UNITED_READ_PLAN(2, "聚合阅读计划");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ItemTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static ItemTypeEnum getByCode(Integer code) {
        for (ItemTypeEnum status : ItemTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
