package cn.yoofans.knowledge.center.api.enums.read;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by zhangshun on 2018/5/22,14:24:05.
 */
public enum ReadStateEnum {

    WAIT_ONLINE(1, "待上线"), ONLINE(2, "已上线"), OFF_ONLINE(3, "已下线");

    private Integer code;

    private String desc;

    ReadStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, ReadStateEnum> typeMap = Maps.newHashMap();

    static {
        for (ReadStateEnum readStateEnum : ReadStateEnum.values()) {
            typeMap.put(readStateEnum.getCode(), readStateEnum);
        }
    }

    public static ReadStateEnum getByCode(Integer code) {
        return typeMap.get(code);
    }

}
