package cn.yoofans.knowledge.center.api.enums.refund;

import java.util.Objects;

/**
 * 订单分销类型枚举
 * Created by qiuyp
 */
public enum OrderDistributionTypeEnum {

    NO_DISTRIBUTION(1, "无分销订单"),
    CHANNEL_DISTRIBUTION(2, "渠道分销订单"),
    COMMON_DISTRIBUTION(3, "普通分销员分销订单"),
    INVITE_DISTRIBUTION(4, "邀请分销订单");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    OrderDistributionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static OrderDistributionTypeEnum getByCode(Integer code) {
        for (OrderDistributionTypeEnum value : OrderDistributionTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
