package cn.yoofans.knowledge.center.api.enums.refund;

import java.util.Objects;

/**
 * 操作状态枚举
 * Created by qiuyp
 */
public enum RefundOperationStatusEnum {
    WAIT_CALLBACK("WAIT_CALLBACK", "待回调 "),
    QUERYING("QUERYING", "查询中"),
    SUCCESS("SUCCESS", "处理成功"),
    FAIL("FAIL", "处理失败");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    RefundOperationStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static RefundOperationStatusEnum getByCode(String code) {
        for (RefundOperationStatusEnum value : RefundOperationStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(String code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
