/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteGoodsGroupService
 * Author:   amu
 * Date:     2018/4/9 下午9:29
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.GoodsGroupDTO;
import cn.yoofans.knowledge.center.api.dto.GoodsListDTO;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈〉
 *
 * @author amu
 * @create 2018/4/9
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteGoodsGroupService {
    /**
     * 分页查询的数据
     * @param goodsGroupName
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<GoodsGroupDTO> findByPage(String goodsGroupName, Integer pageNum, Integer pageSize);

    /**
     * 分页查询的总数
     * @param goodsGroupName
     * @return
     */
    Long findByPageCount(String goodsGroupName);


    /**
     * 新增
     * @param goodsGroupDTO
     * @return
     */
    GoodsGroupDTO insert(GoodsGroupDTO goodsGroupDTO);

    /**
     * 修改
     * @param goodsGroupDTO
     * @return
     */
    Boolean update(GoodsGroupDTO goodsGroupDTO);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 按照ID查找
     * @param id
     * @return
     */
    GoodsGroupDTO findById(Long id);

    /**
     * 根据商品分组id获取商品列表
     * @param id 商品组id
     * @param limit 取得个数
     * @param columnStatus 专栏状态
     * @param courseStatus 单课状态
     * @return
     */
    List<GoodsListDTO> getGoogsListByGroupId(Long id,Integer limit,Short columnStatus,Short courseStatus);

}
