/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteUserPlaybackProgressService
 * Author:   amu
 * Date:     2018/4/27 下午7:41
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.UserPlaybackProgressDTO;
import cn.yoofans.knowledge.center.api.param.RemotePlayProgressParams;
import cn.yoofans.knowledge.center.api.param.UserPlayProgressParams;
import cn.yoofans.knowledge.center.api.param.playprogress.UserPlayFinishParams;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author amu
 * @create 2018/4/27
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteUserPlaybackProgressService {

    /**
     * 按照客户和专栏id查询
     *
     * @return
     */
    List<UserPlaybackProgressDTO> findByConsumerIdAndColumnId(RemotePlayProgressParams remotePlayProgressParams);

    /**
     * 更新用户已购播放进度
     *
     * @param userPlayProgressParams
     * @return
     */

    Boolean updatePlayBackProgress(UserPlayProgressParams userPlayProgressParams);

    /**
     * @author zhangmm
     * @Description: 统计用户收听总时长
     * @date 2018/10/10 0010 16:14
    */
    public Boolean updatePlayBackProgressForCount(UserPlayProgressParams params);
        /**
         * 更新完课状态
         *
         * @param params
         * @return
         */
    Boolean updateFinishState(UserPlayFinishParams params);

    /**
     * 请使用新接口 findNoStudyDaysStageId
     *
     * @param cid
     * @param readId
     * @return
     */
    @Deprecated
    Long findNoStudyDays(Long cid, Long readId);

    /**
     * 查询未学完天数
     *
     * @param cid
     * @param readId
     * @param stageId
     * @return
     */
    Long findNoStudyDaysStageId(Long cid, Long readId, Long stageId);
}
