package cn.yoofans.knowledge.center.api.dto.sns;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import lombok.Data;

import java.util.Date;

/**
 * 微信朋友圈文件同步实体
 */
@Data
public class SnsFileSyncDTO extends BaseDTO {

    /**
     * 文件上传id
     */
    private Long recordId;

    /**
     * 同步时间起
     */
    private Date syncStartTime;

    /**
     * 同步时间止
     */
    private Date syncEndTime;

    /**
     * 处理状态 0-未处理/1-处理中/2-处理成功/3-处理失败
     * #{@link cn.yoofans.knowledge.center.api.enums.sns.SnsProcessStatusEnum}
     */
    private Integer processStatus;

    /**
     * 处理人名称
     */
    private String operatorName;

    /**
     * 备注
     */
    private String remark;

}