package cn.yoofans.knowledge.center.api.enums.sns;

import java.util.Objects;

/**
 * 统计详情类型枚举
 * Created by qiuyp
 */
public enum SnsStatisticsTypeEnum {

    CLOCKED(1, "已打卡"),

    NOT_CLOCK(2, "未打卡"),

    UNCERTAIN_CLOCKED(3, "疑似已打卡"),

    UNCERTAIN_NOT_CLOCK(4, "疑似未打卡");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SnsStatisticsTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static SnsStatisticsTypeEnum getByCode(Integer code) {
        for (SnsStatisticsTypeEnum value : SnsStatisticsTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
