package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.distribution.PosterDTO;

import java.util.List;

/**
 * 海报远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemotePosterService {

    /**
     * 新增海报
     *
     * @param dto
     * @return
     */
    public PosterDTO add(PosterDTO dto);

    /**
     * 删除海报
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id);

    /**
     * 修改海报信息
     *
     * @param dto
     * @return
     */
    public Boolean update(PosterDTO dto) throws BizException;

    /***
     * 修改排序
     *
     * @param posterId
     * @param start
     * @param end
     * @return
     */
    public Boolean sortPosters(Long posterId, Long start, Long end);

    /**
     * 依据Id查询
     *
     * @param id
     * @return
     */
    public PosterDTO findById(Long id);

    /**
     * 查询海报集合
     *
     * @param itemType
     * @param itemId
     * @return
     */
    public List<PosterDTO> findPostersByTypeAndItemId(Integer itemType, Long itemId);

    /**
     * 查询海报数量
     *
     * @param itemType
     * @param itemId
     * @return
     */
    public Integer findCountByTypeAndItemId(Integer itemType, Long itemId);

}
