/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteUserReadCorrectService
 * Author:   amu
 * Date:     2018/10/12 下午2:15
 * Description: 用户阅读已购修正
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.correct;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 〈一句话功能简述〉<br> 
 * 〈用户阅读已购表修正〉
 *
 * @author amu
 * @create 2018/10/12
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteUserReadCorrectService {

    /**
     * 订正用户已购数据
     *  添加read_state
     *  添加buy_state
     *  添加answer_score
     *  添加books
     * @param userId
     * @return
     */
    Boolean updateCorrectUserReadInfo(Long userId) throws Exception;

    /**
     * 订正用户答题结果表
     *  添加read_stage_id
     * @param userId
     * @return
     * @throws Exception
     */
    Boolean updateCorrectUserCourseResult(Long userId) throws Exception;

    /**
     * 订正用户的播放进度
     * @param userId
     * @return
     * @throws Exception
     */
    Boolean updateCorrectUserPlayProgress(Long userId) throws Exception;
}
