/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteUserCourseResult
 * Author:   amu
 * Date:     2018/9/10 下午5:08
 * Description: 用户完课结果
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.question;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.question.UserCourseResultDTO;

import java.util.Date;

/**
 * 〈一句话功能简述〉<br> 
 * 〈用户完课结果〉
 *
 * @author amu
 * @create 2018/9/10
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteCourseResultService {

    /**
     * 查询用户完课结果
     * @param resultDTO
     * @return
     */
    public UserCourseResultDTO findUserCourseResult(UserCourseResultDTO resultDTO);

    /**
     * 按照课程id、时间查询完题的人数
     * @param readId
     * @param courseId
     * @param finishDate
     * @return
     */
    Long countFinishCourseByCourseId(Long readId,Long courseId,Date finishDate);

    /**
     * 根据课程ID、计划ID和期数ID查询满分人数
     * @param courseId
     * @param readId
     * @param readStageId
     * @return
     */
    Long findFullScoreCount(Long readId, Long readStageId,Long courseId);

    /**
     * 根据课程ID、计划ID和期数ID第一个满分用户id
     * @param courseId
     * @param readId
     * @param readStageId
     * @return
     */
    Long findFirstFullScoreUserId(Long readId, Long readStageId,Long courseId);
}
