/*
 * Decompiled with CFR 0.152.
 */
package cn.yoofans.knowledge.center.api.param;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.crazycake.utils.CamelNameUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class BasePageReqParam
implements Serializable {
    private static final long serialVersionUID = 2922776169345436048L;
    public static final String START_INDEX = "startIndex";
    public static final String PAGE_SIZE = "pageSize";
    public static final String ORDER_BY = "orderBy";
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    private Integer startIndex = 0;
    private String columns;
    private String order;

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getStartIndex() {
        if (null == this.pageNum || null == this.pageSize) {
            return 0;
        }
        return (this.pageNum - 1) * this.pageSize;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public BasePageReqParam() {
    }

    public BasePageReqParam(Integer pageNum, Integer pageSize) {
        this.pageNum = null == pageNum ? 1 : pageNum;
        this.pageSize = null == pageSize ? 20 : pageSize;
    }

    public String getOrderBy() {
        if (this.columns == null || this.columns.trim().equals("")) {
            return null;
        }
        StringBuilder orderBy = new StringBuilder("");
        String[] sorts = this.columns.split(",");
        String[] orders = this.order.split(",");
        for (int i = 0; i < sorts.length; ++i) {
            orderBy.append(" " + CamelNameUtils.camel2underscore((String)sorts[i]) + " " + orders[i] + " ,");
        }
        if (!"".equals(orderBy.toString())) {
            orderBy.deleteCharAt(orderBy.length() - 1);
        }
        return orderBy.toString();
    }

    public Pageable getPageable() {
        return new PageRequest(this.pageNum - 1, this.pageSize.intValue());
    }

    public Map<String, Object> getBasePageMap() {
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put(START_INDEX, this.getStartIndex());
        pageMap.put(PAGE_SIZE, this.getPageSize());
        pageMap.put(ORDER_BY, this.getOrderBy());
        return pageMap;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

