/*
 * Decompiled with CFR 0.152.
 */
package cn.yoofans.knowledge.center.api.param;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageParam
implements Serializable {
    private static final long serialVersionUID = 2922776169345436048L;
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    private Integer startIndex;

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setStartIndex(Integer pageNum, Integer pageSize) {
        if (Objects.isNull(pageNum) || 0 == pageNum) {
            this.startIndex = 0;
        }
        if (Objects.isNull(pageSize) || 0 == pageSize) {
            this.startIndex = 0;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        this.startIndex = (pageNum - 1) * pageSize;
    }

    public Integer getStartIndex() {
        if (Objects.isNull(this.pageNum) || 0 == this.pageNum) {
            this.startIndex = 0;
        }
        if (Objects.isNull(this.pageSize) || 0 == this.pageSize) {
            this.startIndex = 0;
        }
        if (this.pageNum < 1) {
            this.pageNum = 1;
        }
        this.startIndex = (this.pageNum - 1) * this.pageSize;
        return this.startIndex;
    }

    public Pageable getPageable() {
        return new PageRequest(this.pageNum - 1, this.pageSize.intValue());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

