package cn.yoofans.knowledge.center.api.dto.sns;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import cn.yoofans.knowledge.center.api.enums.sns.SnsReviewEnum;
import lombok.Data;

import java.util.Date;

/**
 * 数据审核实体类
 */
@Data
public class SnsReviewDTO extends BaseDTO {
    /**
     * 审核时间起
     */
    private Date startReviewTime;

    /**
     * 审核时间止
     */
    private Date endReviewTime;


    /**
     * 系统打卡数
     */
    private Integer sysClockNum;

    /**
     * 朋友圈打卡数量
     */
    private Integer snsClockNum;

    /**
     * 成功打卡数
     */
    private Integer clockedNum;
    /**
     * 未打卡数
     */
    private Integer notClockNum;

    /**
     * 疑似打卡数
     */
    private Integer uncertainClockedNum;

    /**
     * 疑似为打卡数
     */
    private Integer uncertainNotClockNum;

    /**
     * 处理状态
     * #{@link SnsReviewEnum}
     */
    private Integer processStatus;

    /**
     * 审核员名称
     */
    private String operatorName;

    /**
     * 备注
     */
    private String remark;

}