package cn.yoofans.knowledge.center.api.enums;

/**
 * Created by zhangshun on 2018/10/17,12:30:22.
 */
public enum ChannelTypeEnum {

    CPS(1, "CPS"),

    DIRECT(2, "直投"),

    COLLEGE(3, "学校"),

    OTHER(4, "其他");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ChannelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static ChannelTypeEnum getByCode(Integer code) {
        for (ChannelTypeEnum status : ChannelTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static String getNameByCode(Integer code) {
        for (ChannelTypeEnum status : ChannelTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
