package cn.yoofans.knowledge.center.api.enums;

/**
 * 用户类型枚举
 * @author zhanghuifeng
 * @date 2018/7/31下午7:42
 */
public enum ConsumerTypeEnum {

    NORMAL(1, "正常用户"),
    VIRTUAL(2, "虚拟用户");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ConsumerTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static ConsumerTypeEnum getByCode(Integer code) {
        for (ConsumerTypeEnum status : ConsumerTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
