package cn.yoofans.knowledge.center.api.enums.jdgiftbook;

/**
 * @Author danke
 * @Date :Create in 下午4:18 2018/10/16
 */
public enum JDOrderStatusEnum {

    JD_ORDER_STATUS_SEND(16L, "京东已发货"),

    JD_ORDER_STATUS_WAITING_PAY(2L, "等待支付"),

    JD_DISPATCHING_CANCLE(0L, "订单已取消");

    /**
     * 代码
     */
    private long code;

    /**
     * 描述
     */
    private String desc;

    JDOrderStatusEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static JDOrderStatusEnum getByCode(Long code) {
        for (JDOrderStatusEnum status : JDOrderStatusEnum.values()) {
            if (status.code == code.longValue()) {
                return status;
            }
        }
        return null;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
