package cn.yoofans.knowledge.center.api.param.jdBean;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangmm
 * @Description: 京东接口返回参数
 * @date 2018/9/4 000414:43
 */
@Data
public class JDresult<T> implements Serializable {

    private static final long serialVersionUID = 2962109692235573776L;
    private static final String DEFAULT_RESULT_CODE = "9999";

    boolean success;
    String resultMessage;
    String resultCode;
    T result;

    public JDresult() {
        // Do nothing
    }

    public boolean hasSuccessValue() {
        return this.success && this.result != null;
    }

    public JDresult<T> setRightReturn(T value) {
        this.success = true;
        this.result = value;
        return this;
    }

    public static <T> JDresult<T> rightReturn(T value) {
        return (new JDresult()).setRightReturn(value);
    }

    public JDresult<T> setErrorReturn(String errorMsg) {
        this.resultMessage = errorMsg;
        this.success = false;
        this.resultCode = DEFAULT_RESULT_CODE;
        return this;
    }

    public JDresult<T> setErrorReturn(String errorMsg,String errorCode) {
        this.resultMessage = errorMsg;
        this.success = false;
        this.resultCode = errorCode;
        return this;
    }

    public static <T> JDresult<T> errorReturn(String errorMsg) {
        return (new JDresult()).setErrorReturn(errorMsg);
    }

    public static <T> JDresult<T> errorReturn(String errorMsg,String errorCode) {
        return (new JDresult()).setErrorReturn(errorMsg,errorCode);
    }
}
