package cn.yoofans.knowledge.center.api.param.sale;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

import cn.yoofans.knowledge.center.api.util.NumberUtils;

/**
 * Created by zhangshun on 2018/10/16,13:46:57.
 */
public class SaleParams implements Serializable {

    /**
     * 推广位ID
     */
    private Long adzoneId;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 最近几天
     */
    private Integer days = 1;

    public Long getAdzoneId() {
        return adzoneId;
    }

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * 验证 推广位id 和 渠道id 同时为空
     *
     * @return
     */
    public boolean validate() {
        if (NumberUtils.isNullOrZero(adzoneId) && NumberUtils.isNullOrZero(channelId)) {
            return true;
        }
        if (!NumberUtils.isNullOrZero(adzoneId) && !NumberUtils.isNullOrZero(channelId)) {
            return true;
        }
        return false;
    }

    public Date getStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);

        if (0 >= days - 1) {
            return calendar.getTime();
        }

        calendar.add(Calendar.DATE, -(days - 1));
        return calendar.getTime();
    }

    public Date getEndTime() {

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);

        return calendar.getTime();
    }

}
