package cn.yoofans.knowledge.center.api.remoteservice;

import java.util.List;

import org.springframework.data.domain.PageImpl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.AdzoneDTO;

/**
 * 推广位远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteAdzoneService {

    /**
     * 新增推广位
     *
     * @param dto
     * @return
     */
    public AdzoneDTO add(AdzoneDTO dto) throws BizException;

    /**
     * 删除推广位
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改推广位基本信息
     *
     * @param dto
     * @return
     */
    public Boolean update(AdzoneDTO dto) throws BizException;

    /**
     * 依据Id查询推广位
     *
     * @param id
     * @return
     */
    public AdzoneDTO findById(Long id) throws BizException;

    /**
     * 分页查询推广位信息
     *
     * @param id
     * @param name
     * @param channelId
     * @param channleName
     * @param pageNum
     * @param pageSize
     * @return
     */
    public PageImpl<AdzoneDTO> getPageList(Long id, String name, Long channelId, String channleName, Integer pageNum,
        Integer pageSize);

    /**
     * 依据channelId查询推广位列表
     *
     * @param channelId
     * @return
     */
    public List<AdzoneDTO> findListByChannelId(Long channelId);

    Long findByChannelIdCount(Long channelId);

    List<AdzoneDTO> findByChannelId(Long channelId, Integer pageNum, Integer pageSize);

    /**
     * 根据销售用户ID查询
     *
     * @param saleUserId
     * @return
     */
    AdzoneDTO getBySaleUserId(Long saleUserId);

}
