package cn.yoofans.knowledge.center.api.remoteservice;

import java.util.List;

import org.springframework.data.domain.PageImpl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.ChannelDTO;

/**
 * 渠道远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteChannelService {

    /**
     * 新增渠道
     *
     * @param dto
     * @return
     */
    public ChannelDTO add(ChannelDTO dto) throws BizException;

    /**
     * 删除渠道
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改渠道基本信息
     *
     * @param dto
     * @return
     */
    public Boolean update(ChannelDTO dto) throws BizException;

    /**
     * 依据Id查询渠道
     *
     * @param id
     * @return
     */
    public ChannelDTO findById(Long id) throws BizException;

    /**
     * 分页查询渠道列表
     *
     * @param id
     * @param name
     * @param pageNum
     * @param pageSize
     * @return
     */
    public PageImpl<ChannelDTO> getPageList(Long id, String name, Integer pageNum, Integer pageSize);

    /**
     * 查询渠道列表
     *
     * @param id
     * @param name
     * @return
     */
    public List<ChannelDTO> getList(Long id, String name);

    /**
     * 根据渠道类型查询
     *
     * @param type
     * @return
     */
    List<ChannelDTO> findByType(Integer type);

    /**
     * 批量查询
     *
     * @param idList
     * @return
     */
    List<ChannelDTO> findByIdList(List<Long> idList);

    /**
     * 根据销售用户ID查询
     *
     * @param saleUserId
     * @return
     */
    ChannelDTO getBySaleUserId(Long saleUserId);

}
