package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponInfoItemDTO;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponInfoItemFullInfoDTO;

import java.util.List;

/**
 * 优惠券关联商品信息接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteCouponInfoItemService {

    /**
     * 根据couponId查询
     *
     * @param couponId
     * @return
     */
    List<CouponInfoItemDTO> getListByCouponId(String couponId);

    /**
     * 根据couponId查询
     *
     * @param couponId
     * @return
     */
    List<CouponInfoItemFullInfoDTO> getFullInfoListByCouponId(String couponId);

    /**
     * 依据优惠券id删除关联的商品信息
     *
     * @param couponId
     * @return
     */
    Boolean deleteByCouponId(String couponId);

}
