package cn.yoofans.knowledge.center.api.remoteservice.college;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.college.CollegeDto;
import cn.yoofans.knowledge.center.api.param.college.CollegeParam;

/**
 * 活动奖励接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteCollegeService {

    /**
     * 保存数据
     *
     * @param collegeDto
     * @return
     */
    Boolean save(CollegeDto collegeDto);

    /**
     * ID查询
     *
     * @param id
     * @return
     */
    CollegeDto getById(Long id);

    CollegeDto getByName(String name);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    Long countByParam(CollegeParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<CollegeDto> findByParam(CollegeParam param);
}
