/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteQuestionRecordService
 * Author:   amu
 * Date:     2018/9/12 下午1:56
 * Description: 用户答题记录
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.question;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.question.UserQuestionRecordDTO;

/**
 * 〈一句话功能简述〉<br> 
 * 〈用户答题记录〉
 *
 * @author amu
 * @create 2018/9/12
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteQuestionRecordService {

    /**
     * 按照课程查询用户答题记录
     * @param userId  用户id
     * @param courseId 课程id
     * @return
     */
    List<UserQuestionRecordDTO> findQuestionRecord(Long userId,Long courseId,Long readId);

}
