package cn.yoofans.knowledge.center.api.remoteservice.read;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.*;
import cn.yoofans.knowledge.center.api.enums.ConsumerReadTypeEnum;
import cn.yoofans.knowledge.center.api.param.read.RemoteReadPastParam;
import org.springframework.data.domain.PageImpl;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2018/5/23,10:45:42.
 */
@AdvancedFeignClient
public interface RemoteUserReadService {

    /**
     * 更新用户读书信息
     *
     * @param userReadDto
     * @return
     */
    boolean updateById(UserReadDto userReadDto);

    /**
     * 获取用户读书开课日期
     *
     * @param userId
     * @return
     */
    Date getBeginDate(Long userId);

    /**
     * 获取用户阅读
     *
     * @param orderId 订单ID
     * @return
     */
    UserReadDto getReadByOrderId(String orderId);

    /**
     * 获取用户阅读
     *
     * @param userId 用户ID
     * @return
     */
    UserReadTeacherDto getReadByUserId(Long userId);

    /**
     * 获取用户阅读
     *
     * @param userId 用户ID
     * @param readId 阅读ID
     * @return
     */
    UserReadDto getReadByUserAndRead(Long userId, Long readId);

    /**
     * 获取用户阅读状态
     *
     * @param userId    用户ID
     * @param clockDate 操作日志
     * @return
     */
    UserReadStateDetailDTO getReadStateDetail(Long userId, Date clockDate);

    /**
     * 获取今日课程
     *
     * @param userId    用户ID
     * @param clockDate 操作时间
     * @return
     */
    UserReadCourseDTO getUserReadCourse(Long userId, Date clockDate);

    /**
     * 更新海报URL
     *
     * @param userId
     * @return
     */
    boolean updateDiplomaImgUrl(Long userId, Long readId, String imgUrl,Long courseId);

    /**
     * 查询用户已购
     *
     * @param readId
     * @return
     */
    List<UserReadDto> getByRead(Long readId);

    /**
     * 查询用户已购
     *
     * @param userId
     * @return
     */
    List<UserReadDto> findByUser(Long userId);

    /**
     * 往期阅读
     *
     * @param remoteReadPastParams
     * @return
     */
    PageImpl<ReadSimpleDTO> findByPage(RemoteReadPastParam remoteReadPastParams);

    /**
     * 查询我的已购阅读的结束时间
     *
     * @param userId
     * @return
     */
    Map<String, String> getExpDateByUserId(Long userId);

    /**
     * 获取最大过期日期的已购阅读
     *
     * @param userId
     * @return
     */
    UserReadDto getNewestByUserId(Long userId);

    /**
     * 获取用户最新的阅读信息
     *
     * @param userId
     * @return
     */
    UserNewestReadDTO getUserNewestReadInfo(Long userId);

    /**
     * 获取用户结业海报地址
     *
     * @param userId
     * @param readId
     * @return
     */
    String getDiplomaImgUrl(Long userId, Long readId);

    /**
     * 下单时,获取阅读期数
     *
     * @param userId 用户Id
     * @param readId 阅读Id
     * @return
     */
    Long getStageId(Long userId, Long readId);

    /**
     * 获取复购状态
     *
     * @param userId
     * @return
     */
    Integer getRebuyState(Long userId);

    Boolean containsSaleMark(Long userId, Long readId, Integer saleMark);

    /**
     * 判断用户类型
     * 暂时只有新用户和老用户2中
     * enum-ConsumerReadTypeEnum
     */
    ConsumerReadTypeEnum getUserReadType(Long userId);


    /**
     * 获取用户阅读计划购买记录
     *
     * @param userId 用户ID
     * @param readId 阅读ID
     * @return
     */
    UserReadDto getReadByUserIdAndReadId(Long userId, Long readId);

    /**
     * 设置期数激活体验课程
     * @param userId
     * @param readId
     * @return
     */
    Boolean activateExperienceRead(Long userId,Long readId);
    /**
     * 获取某一期阅读计划,用户购买情况
     *
     * @param readStageId 阅读计划期数ID
     * @param readId 阅读ID
     * @return
     */
    List<UserReadDto> getReadByStageAndReadId(Long readId, Long readStageId);

}
