package cn.yoofans.manager.center.api.param;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 基本分页请求参数
 * 
 * @author qiuyp
 *
 */
public class BasePageRequestParam implements Serializable{

	private static final long serialVersionUID = 7900613074688308736L;

	/**
	 * 页码，默认页码为1
	 */
	private Integer pageNum = 1;

	/**
	 * 分页大小，默认分页大小为20
	 */
	private Integer pageSize = 20;

	public Integer getPageNum() {
		return pageNum;
	}

	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public BasePageRequestParam() {
		super();
	}

	public BasePageRequestParam(Integer pageNum, Integer pageSize) {
		super();
		this.pageNum = null == pageNum ? 1 : pageNum;
		this.pageSize = null == pageSize ? 20 : pageSize;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
