package cn.yoofans.manager.center.api.remoteservice;

import java.util.List;

import org.springframework.data.domain.PageImpl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.ContentTypeDTO;

/**
 * 小程序内容管理类型远程调用Service
 * 
 * @author qiuyp
 *
 */
@AdvancedFeignClient
public interface RemoteContentTypeService {

	/**
	 * 新增类型
	 * 
	 * @param contentTypeDTO
	 * @return
	 */
	public ContentTypeDTO add(ContentTypeDTO dto) throws BizException;

	/**
	 * 删除类型
	 * 
	 * @param id
	 * @return
	 */
	public Boolean delete(Long id) throws BizException ;

	/**
	 * 修改类型
	 * 
	 * @param updateDTO
	 * @return
	 */
	public Boolean update(ContentTypeDTO dto) throws BizException;

	/**
	 * 依据Id查询类型
	 * 
	 * @param id
	 * @return
	 */
	public ContentTypeDTO findById(Long id) throws BizException;

	/**
	 * 获取所有的一级类型列表或某一级类型对应的所有二级类型列表
	 * 
	 * @param parentId
	 * @return
	 */
	public List<ContentTypeDTO> getListByParentId(Long parentId) throws BizException;

	/**
	 * 分页查询类型列表
	 * 
	 * @param queryParam
	 * @return
	 */
	public PageImpl<ContentTypeDTO> getPageList(Integer pageNum, Integer pageSize);
	
	/**
	 * 依据name查询类型
	 * 
	 * @param id
	 * @return
	 */
	public ContentTypeDTO findByName(String name) throws BizException;
	
	/**
	 * 依据names查询类型
	 * 
	 * @param id
	 * @return
	 */
	public List<ContentTypeDTO> findByNames(List<String> names) throws BizException;

	/**
	 * 插入小程序类型
	 * 2018.4 需求
	 * @param dto
	 * @return
	 */
	ContentTypeDTO insertAppType(ContentTypeDTO dto);

	/**
	 * 修改小程序类型
	 * 2018.4 需求
	 * @param dto
	 * @return
	 */
	Boolean updateAppType(ContentTypeDTO dto);

	/**
	 * 分页
	 * 2018.4 需求
	 * @return
	 */
	List<ContentTypeDTO> findAppTypeByPage(String name,Integer modelType,Integer pageNum, Integer pageSize);

	/**
	 * 总数
	 * 2018.4 需求
	 * @return
	 */
	Long findAppTypeByPageCount(String name,Integer modelType);

	/**
	 * 删除
	 * @param id
	 * @return
	 */

	Boolean deleteAppType(Long id);

	/**
	 * 获取绑定的类型详情
	 * @return
	 */
	ContentTypeDTO getBandWxAppTypeInfo(Long authorizerId, Byte modelType);




}
