/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemotePutContentService
 * Author:   amu
 * Date:     2018/3/23 下午4:46
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.PutContentDto;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈远程内容管理服务〉
 *
 * @author amu
 * @create 2018/3/23
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemotePutContentService {

    /**
     * 插入
     * @param putContentDto
     * @return
     */
    PutContentDto insert(PutContentDto putContentDto);


    /**
     * 按照id删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 按照id更新
     * @param putContentDto
     * @return
     */

    int updateById(PutContentDto putContentDto);

    /**
     * 分页查询的数据
     * @param subscriptionId
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<PutContentDto> findByPage(Long subscriptionId, Integer pageNum , Integer pageSize);

    /**
     * 分页查询的总数
     * @param subscriptionId
     * @return
     */
    Long findByPageCount(Long subscriptionId);

    /**
     * 按照id查找
     * @param id
     * @return
     */
    PutContentDto findById(Long id);

    /**
     * 获取全部
     * @param subscriptionId
     * @return
     */
    List<PutContentDto> findBySubscriptionId(Long subscriptionId);

}
