package cn.yoofans.manager.center.api.constant;

import cn.yoofans.manager.center.api.enums.message.TriggerConditionEnum;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * Created by qiuyp on 2018/7/12.
 */
public class MsgConfig {

    /**
     * task-center项目使用的缓存key1
     */
    public static final String TASK_KEY_MSG_CONFIG = "MSG_CONFIG:";

    /**
     * task-center项目使用的缓存key前缀
     */
    public static final String MSG_CONTRIGGER_TYPE_CONFIG_CACHE_KEY_PREFIX = "MSG_CONTRIGGER_TYPE_CONFIG:";

    /**
     * 获取task-center项目使用的触发类型缓存key集合
     *
     * @return
     */
    public static List<String> getMsgContriggerTypeConfigCacheKeys() {
        List<String> cacheKeys = Lists.newArrayList();
        for (TriggerConditionEnum trigger : TriggerConditionEnum.values()) {
            cacheKeys.add(MSG_CONTRIGGER_TYPE_CONFIG_CACHE_KEY_PREFIX + trigger.getCode());
        }
        return cacheKeys;
    }

}
