package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 消息内容类型
 * @author zhanghuifeng
 * @date 2018/8/21上午9:51
 */
public enum MsgContentTypeEnum {

    UPLOAD_IMG(1, "上传图片"),
    TEACHER_WEIXIN(2, "老师微信");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    MsgContentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static MsgContentTypeEnum getByCode(Integer code) {
        for (MsgContentTypeEnum value : MsgContentTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        if (null == code) return null;
        for (MsgContentTypeEnum value : MsgContentTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }
}
