package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 消息二级类型
 * Created by qiuyp
 */
public enum MsgSecondaryTypeEnum {

    TEXT_MESSAGE(1, "文字消息"),
    PICTURE_MESSAGE(2, "图片消息"),
    IMG_TEXT_MSG(3, "图文消息");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    MsgSecondaryTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static MsgSecondaryTypeEnum getByCode(Integer code) {
        for (MsgSecondaryTypeEnum value : MsgSecondaryTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        if (null == code) return null;
        for (MsgSecondaryTypeEnum value : MsgSecondaryTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }

}
