package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 触发条件类型
 * Created by qiuyp
 */
public enum TriggerConditionEnum {

    SUBSCRIBE("subscribe", "关注公众号"),
    VIEW("VIEW", "点击菜单"),
    TEXT("text", "发送消息"),
    TIMING("timing", "定时"),
    PAY_TIME_OUT("PAY_TIME_OUT","付款超时"),
    LOOP_TIMING("loop_timing", "定时循环"),
    ORDER_SUBMIT("order_submit", "下单"),
    RECEIVE_COUPON("receive_coupon", "领券"),
    PAY_SUCCESS("pay_success", "付款成功"),
    BEFORE_CLASS_16("before_class_16", "开课前16小时"),
    CLASS_OVER("class_over", "结课"),
    NOT_INTERACT_48("not_interact_48", "48小时未互动");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    TriggerConditionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static TriggerConditionEnum getByCode(String code) {
        for (TriggerConditionEnum value : TriggerConditionEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(String code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (null == code) return null;
        for (TriggerConditionEnum value : TriggerConditionEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }

}
